//  estimate      

//      ,
//         
//   .
//        
//      ,
//       ,
//    "",    .
//   ,     ,
//       ,
// ,   ,      ,
//       
//    .
//      ,
//    ,      ,
//     ,
//       ,
//    ,  ,
//      "",  


//  :

// fnUpdate() -     (txt)
// fnEstimate()-      (txt)

//       MsgFile.txt

//     :
// 128     String  dwLen>0,   pHash
// void fnHash128(BYTE * pHash,BYTE * String, DWORD dwLen)
// int fnCompareHash(DWORD * Hash1,DWORD * Hash2)//  
// bool fnFindHash(DWORD * Hash)//     
// void fnInsertHash(DWORD * Hash)//     


/******************************************************************************/
//                         
/******************************************************************************/
#include <windows.h>      // Win32
#include <winbase.h>      // Windows Base APIs
#include <wingdi.h>       //  GDI
#include <winuser.h>      //  USER
#include <commctrl.h>     //   
#include <stdlib.h>       // 
#include <stdio.h>        //  -
#include <math.h>         //  
#include <time.h>         // ( randomize)
#include <string.h>       //  

/******************************************************************************/
//                         
/******************************************************************************/
#define MENU_ESTIMATE       101      //     

#define MENU_UPDATE         104      //    

#define MENU_ABOUT          111      //  
#define MENU_EXIT           112      //  
#define MENU_TEST           113      //  (   )

/******************************************************************************/
/*                                                        */
/******************************************************************************/
HINSTANCE  hInstance;                   //  () 
HWND       hWndMain=NULL;               //    
HWND       hWndStatus=NULL;             //   
char       szAppName[]="Estimate",      //  
    //    
    szMainWindowTitle[]="   :   ",
    szHashFile[]="Hash128.dat",//   
    szStatFile[]="Stat.dat",   //   
    szExeDir[256],             //   
    szBuffer[256];             //    - 
                               // dwlChainsNumber<4294967295
// -,  - ,   .
//  - 128 .
DWORD * HashTable=NULL;        //  
DWORD dwHashCount;             //    
DWORD dwInsertPos;             //  

//   
DWORD dwFileCounter; //    
float fMean;         //       
float fSigma;        //     

//   :
// - ,    fMean-2*fSigma,
// - ,  fMean-2*fSigma  fMean-fSigma
// - ,  fMean-fSigma  fMean+fSigma,
// - ,  fMean+fSigma  fMean+2*fSigma,
// - ,  fMean+2*fSigma

//  
char szTextFile[256];             //   
DWORD dwTextSize=0;               //  
unsigned char * pText=NULL;       //   ( )

HANDLE hMsgFile;                  //  


//  (  )  256 
// (   )
const BYTE RandTable[256]={
  107,78,64,204,226,52,113,139,122,188,145,73,117,18,110,5,209,152,21,47,111,
  71,45,32,105,20,134,132,147,191,121,253,242,239,92,67,41,199,58,130,214,255,
  166,57,174,161,141,160,116,4,44,250,144,241,137,246,76,155,1,133,49,185,72,
  189,212,104,16,123,243,115,114,99,40,108,80,89,3,81,171,182,60,120,149,236,
  207,69,146,50,193,208,135,109,34,205,112,102,33,9,98,179,158,35,11,2,27,75,
  142,62,8,0,168,101,118,65,131,143,128,157,127,217,218,79,17,167,86,183,233,
  181,10,12,154,28,26,148,77,230,106,54,48,206,74,229,245,53,231,198,140,162,
  238,187,59,190,61,14,37,36,100,173,119,247,232,129,7,164,175,39,215,216,192,
  150,249,6,237,223,184,126,240,151,95,24,51,66,42,23,178,221,153,254,125,124,
  197,15,251,29,194,85,196,31,234,90,210,136,186,38,211,13,91,213,43,244,248,
  235,203,195,25,138,68,252,201,30,46,176,170,219,82,202,19,70,83,96,22,103,
  163,225,180,222,227,94,177,220,172,200,159,97,87,63,56,169,55,156,88,228,93,
  84,224,165};

/******************************************************************************/
/*                                                      */
/******************************************************************************/
// 128     String  dwLen>0,   pHash
void fnHash128(BYTE * pHash,BYTE * String, DWORD dwLen)
{ //    
  pHash[0]=115,  pHash[1]=104,  pHash[2]=78,   pHash[3]=201,
  pHash[4]=157,  pHash[5]=168,  pHash[6]=133,  pHash[7]=34,
  pHash[8]=125,  pHash[9]=97,   pHash[10]=130, pHash[11]=238,
  pHash[12]=194, pHash[13]=209, pHash[14]=158, pHash[15]=188;

  DWORD Bound=17;//   
  if(dwLen>Bound) Bound=dwLen;
  DWORD c=242;//    RandTable
  for(DWORD i=0,j=0, r=0;r<Bound;r++)
  { if(i==0)
    { pHash[0]^=pHash[15]^String[j]^RandTable[c];
      c^=pHash[0];
      i=1;
    }
    else
    { pHash[i]^=pHash[i-1]^String[j]^RandTable[c];
      c^=pHash[i-1];
      i++; if(i==16) i=0;
    }
    j++; if(j==dwLen) j=0;
  }
}//  fnHash128

//  
int fnCompareHash(DWORD * Hash1,DWORD * Hash2)
{ for(int i=0;i<4;i++)
  { if(Hash1[i]>Hash2[i]) return 1;
    if(Hash1[i]<Hash2[i]) return -1;
  }
  return 0;
}/*  fnCompareHash  */


//     
//   ,   true
//   false, dwInsertPos -    
bool fnFindHash(DWORD * Hash)
{ DWORD dwLeft=0;  DWORD dwRight=dwHashCount;
  while(dwLeft<dwRight)
  { DWORD dwMiddle=(dwLeft+dwRight)>>1;
    switch(fnCompareHash(Hash,&HashTable[4*dwMiddle]))
    { case -1:  dwRight=dwMiddle;    break;
      case 1:   dwLeft=dwMiddle+1;   break;
      default:  //dwInsertPos=dwMiddle;
        return true;
    }
  }//   
  dwInsertPos=dwLeft;
  return false;
}/*  fnFindHash  */

//   
//   !
void fnInsertHash(DWORD * Hash)
{
  if(dwHashCount==67108864)
  {//   " "   
    MessageBox(hWndMain,"dwHashCount==67108864","fnInsertHash",MB_OK);
    SendMessage (hWndMain, WM_CLOSE, 0,0);
    return;
  }
  if(GlobalSize(HashTable)<16*(dwHashCount+1))
  {// 
    DWORD * temp=(DWORD*)GlobalAlloc(GPTR,16*(dwHashCount+1));
    CopyMemory (temp,HashTable,16*dwHashCount);
    GlobalFree(HashTable);   HashTable=temp;
  }
    MoveMemory(&HashTable[4*(dwInsertPos+1)],
            &HashTable[4*dwInsertPos],
            16*(dwHashCount-dwInsertPos));//   !

  CopyMemory (&HashTable[4*dwInsertPos],Hash,16);

  dwHashCount++;//   
}/*  fnInsertHash  */

//  
void fnDisableMenu()
{ HMENU hMenu=GetMenu(hWndMain);
  for(DWORD i=100;i<114;i++)
    EnableMenuItem(hMenu, i, MF_GRAYED);
}/*  fnDisableMenu  */

//  
void fnEnableMenu()
{ HMENU hMenu=GetMenu(hWndMain);
  for(DWORD i=100;i<114;i++)
    EnableMenuItem(hMenu, i, MF_ENABLED);
}/*  fnEnableMenu  */

//   
void fnSaveHash128 ()
{ fnDisableMenu();
  sprintf(szBuffer,
    "  , %u . , ...",
     dwHashCount);
  SendMessage (hWndStatus, WM_SETTEXT, 0,(LPARAM)(LPCTSTR) szBuffer);

  SetCurrentDirectory(szExeDir);
  HANDLE hFile = CreateFile (szHashFile, GENERIC_WRITE,
         0, NULL, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
  DWORD dwNOB;
  WriteFile(hFile,HashTable,16*dwHashCount,&dwNOB,NULL);
  CloseHandle(hFile);

  fnEnableMenu();
  SendMessage (hWndStatus, WM_SETTEXT, 0,(LPARAM)"  ");
}/*  fnSaveHash  */

//   
void fnLoadHash128()
{
  fnDisableMenu();
  SetCurrentDirectory(szExeDir);
  HANDLE hFile = CreateFile (szHashFile, GENERIC_READ,
         0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
  if(hFile==INVALID_HANDLE_VALUE)
  {//   
    HashTable=(DWORD *)GlobalAlloc(GPTR,16);
    //     (   )
    dwHashCount=0;
    fnSaveHash128();
    return;
  }
  DWORD dwBytesRead;
  //  
  dwHashCount=GetFileSize(hFile, NULL);//    
  HashTable=(DWORD *)GlobalAlloc(GPTR,dwHashCount+16);

    sprintf(szBuffer,
  "  , %u . , ...",
    dwHashCount/16);
    SendMessage (hWndStatus, WM_SETTEXT, 0,(LPARAM)(LPCTSTR) szBuffer);


  ReadFile(hFile,HashTable,dwHashCount,&dwBytesRead, NULL);
  dwHashCount/=16;
  CloseHandle(hFile);
  fnEnableMenu();

  SendMessage (hWndStatus, WM_SETTEXT, 0,(LPARAM)(LPCTSTR)"  ");
}/*  fnLoadHash  */

//   .       
bool fnLoadText()
{  OPENFILENAME ofn;                   //    
  char strCustomFilter[40];
  ZeroMemory (strCustomFilter, 40);  //  strCustomFilter 
  char strFilter[]="All *.*\0*.*\0 *.txt\0*.txt\0\0";
  //  OPENFILENAME
  ZeroMemory (&ofn, sizeof(OPENFILENAME));  //  opfn 
  ofn.lStructSize = sizeof(OPENFILENAME);
  ofn.hwndOwner = hWndMain;  ofn.lpstrFilter =strFilter;
  ofn.lpstrCustomFilter=strCustomFilter;
  ofn.nMaxCustFilter=sizeof(strCustomFilter);
  ofn.lpstrFile = szTextFile;  ofn.nMaxFile = sizeof (szTextFile);
  ofn.nFilterIndex = 2;
  ofn.lpstrTitle="===     ===";
  ofn.Flags=OFN_EXPLORER|OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST|OFN_HIDEREADONLY;
  //   "".
  if (GetOpenFileName (&ofn))
  {  HANDLE hFile = CreateFile (ofn.lpstrFile, GENERIC_READ,
         0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
    if(hFile==INVALID_HANDLE_VALUE) return false;
    dwTextSize=GetFileSize(hFile, NULL);//    
    //     
    if(pText) GlobalFree(pText);
    pText=(BYTE *)GlobalAlloc(GPTR,dwTextSize);
    DWORD dwBytesRead;
    //  
    ReadFile(hFile,(LPVOID)pText,dwTextSize, &dwBytesRead, NULL);
    CloseHandle(hFile);
    return true;//     
  }
  return false;
}/*  fnLoadText  */

//  
void fnSaveStat()
{ SetCurrentDirectory(szExeDir);
  HANDLE hFile = CreateFile (szStatFile, GENERIC_WRITE,
         0, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
  if(hFile==INVALID_HANDLE_VALUE)
  { MessageBox(hWndMain,"hFile==INVALID_HANDLE_VALUE","fnSaveStat",MB_OK);
    return;
  }
  DWORD dwNOB;
  WriteFile(hFile,&dwFileCounter,sizeof(dwFileCounter),&dwNOB,NULL);
  WriteFile(hFile,&fMean,sizeof(fMean),&dwNOB,NULL);
  WriteFile(hFile,&fSigma,sizeof(fSigma),&dwNOB,NULL);
  CloseHandle(hFile);
}/*  fnSaveStat  */

//  
void  fnLoadStat()
{ HANDLE hFile = CreateFile (szStatFile, GENERIC_READ,
         0, NULL, OPEN_EXISTING, FILE_ATTRIBUTE_NORMAL, NULL);
  if(hFile==INVALID_HANDLE_VALUE)
  {//  
    dwFileCounter=0; //    
    fMean=1.0;//       
    fSigma=0.0;//  
    fnSaveStat();
    return;
  }
  DWORD dwBytesRead;
  ReadFile(hFile,&dwFileCounter,sizeof(dwFileCounter),&dwBytesRead, NULL);
  ReadFile(hFile,&fMean,sizeof(fMean),&dwBytesRead, NULL);
  ReadFile(hFile,&fSigma,sizeof(fSigma),&dwBytesRead, NULL);
  CloseHandle(hFile);
}/*  fnLoadStat  */

//  ,  
void fnTest()
{
  sprintf(szBuffer," :\n"
                   "dwFileCounter = %u\n"
                   "fMean = %f\n"
                   "fSigma = %f",
  dwFileCounter,fMean,fSigma);
  MessageBox(hWndMain,szBuffer,"fnTest",MB_OK);
}/*  fnTest  */

//      pString,  dwLen
DWORD fnDetect(DWORD dwLen,BYTE * pString)
{ DWORD dwDetect=0; //    
  DWORD dwMulti=0;  //    
  DWORD dwLength=1; //   
  for(DWORD dwPos=0;dwPos<dwLen;dwPos+=dwLength)
  {//   
    if((dwPos>>10)==dwMulti)//     
    { sprintf(szBuffer," %s,  %u ,  %u,  %u."
                       " , ...",
                  szTextFile,dwLen,dwPos,dwHashCount);
      SendMessage(hWndStatus,SB_SETTEXT,0,(LPARAM)szBuffer);
      dwMulti++;
    }
    //   
    DWORD Hash[4];
    fnHash128((BYTE*)Hash,pString+dwPos, dwLength);
    while(fnFindHash(Hash))// ,      
    {//  
      dwLength++;//    
      if((dwPos+dwLength>=dwLen)||(dwLength==256)) goto EXITLOOP;// 
      fnHash128((BYTE*)Hash,pString+dwPos, dwLength);
    }
    EXITLOOP:
    if(dwLength!=1) dwLength--;
    dwDetect++;//    ,  
  }
  return dwDetect;
}/*   fnDetect  */
/******************************************************************************/
/*                                                  */
/******************************************************************************/
//     
void fnEstimate()
{ if(!pText)
    if(!fnLoadText())
      return;

  fnDisableMenu();//  

  //   
  DWORD dwDetect=fnDetect(dwTextSize,pText);

  //     
  float fInf=log(dwHashCount)*dwDetect/log(256.0);
  // 
  float fResult=fInf/dwTextSize;
  DWORD dwNOB;
  //  

  WriteFile(hMsgFile,szTextFile,strlen(szTextFile),&dwNOB,NULL);
  sprintf(szBuffer,"\tSize %u,\tInf %f,\tEst %f\t",dwTextSize,fInf,fResult);
  WriteFile(hMsgFile,szBuffer,strlen(szBuffer),&dwNOB,NULL);

  if(fResult<fMean-2.0*fSigma)
    sprintf(szBuffer,"\r\n");
  else
    if(fResult<fMean-fSigma)
      sprintf(szBuffer,"\r\n");
    else
      if(fResult<fMean+fSigma)
        sprintf(szBuffer,"\r\n");
      else
        if(fResult<fMean+2.0*fSigma)
          sprintf(szBuffer,"\r\n");
        else
          sprintf(szBuffer,"\r\n");
  WriteFile(hMsgFile,szBuffer,strlen(szBuffer),&dwNOB,NULL);
  //  
  //  
  if(dwFileCounter)
    fSigma=sqrt( (fSigma*fSigma*(dwFileCounter-1) +
            (fResult-fMean)*(fResult-fMean)) /dwFileCounter);
  else
    fSigma=0.0; //(    0)
  //       ( )
  fMean=(fMean*dwFileCounter+fResult)/(dwFileCounter+1);
  dwFileCounter++; //    
  fnSaveStat(); //  

  GlobalFree(pText); pText=NULL;

  sprintf(szBuffer,"%s, . %u , %f , %f   ",
                  szTextFile,dwTextSize,fInf,fResult);
      SendMessage(hWndStatus,SB_SETTEXT,0,(LPARAM)szBuffer);
  fnEnableMenu();

}/*   fnEstimate  */

//   (   )
void fnUpdate()
{
 if(!pText)
   if(!fnLoadText())
     return;

  fnDisableMenu();//  

  unsigned long ulLen;//   
  DWORD dwStartTick=GetTickCount();//    

  sprintf(szBuffer," %s,  %u ,  %u,  %u."
                   " , ...",
                    szTextFile,dwTextSize>>10,0,dwHashCount);
        SendMessage(hWndStatus,SB_SETTEXT,0,(LPARAM)szBuffer); //WM_PAINT

  DWORD dwMulti=1;
  for(DWORD dwPos=0;dwPos<dwTextSize;dwPos+=ulLen)
  {//   
    ulLen=1;
    if((dwPos>>10)==dwMulti)//     
    { sprintf(szBuffer," %s,  %u ,  %u,  %u."
                       " , ...",
                  szTextFile,dwTextSize>>10,dwPos>>10,dwHashCount);
      SendMessage(hWndStatus,SB_SETTEXT,0,(LPARAM)szBuffer); //WM_PAINT
      dwMulti++;
    }
    DWORD Hash[4];
    fnHash128((BYTE*)Hash,pText+dwPos, ulLen);
    while(fnFindHash(Hash))
    {
      ulLen++;
      if((dwPos+ulLen>=dwTextSize)||(ulLen==256)) goto EXITLOOP;
      fnHash128((BYTE*)Hash,pText+dwPos, ulLen);
    }
    fnInsertHash(Hash);
  }
  EXITLOOP:
  fnSaveHash128();

  DWORD dwNOB;
  sprintf(szBuffer," : ");
  WriteFile(hMsgFile,szBuffer,strlen(szBuffer),&dwNOB,NULL);
  //   
  WriteFile(hMsgFile,szTextFile,strlen(szTextFile),&dwNOB,NULL);
  DWORD dwTick=GetTickCount()-dwStartTick;
  float fKbPerHour=1.0e+38;
  if(dwTick!=0)
    fKbPerHour=(dwTextSize*3508.59375)/dwTick;
  sprintf(szBuffer,"   %f   \r\n",fKbPerHour);
  SendMessage(hWndStatus,SB_SETTEXT,0,(LPARAM)szBuffer); //WM_PAINT
  WriteFile(hMsgFile,szBuffer,strlen(szBuffer),&dwNOB,NULL);

  GlobalFree(pText); pText=NULL;

  fnEnableMenu();//  
}/*   fnUpdate  */

//  
void fnAbout()
{
  MessageBox(hWndMain,
  " estimate      \n\n"

  " 1.0\n\n"

  "     ,\n"
  "        \n"
  "  .\n\n"

  "       \n"
  "     ,\n"
  "      ,\n"
  "   \"\",    .\n\n"

  "  ,     ,\n"
  "      ,\n"
  ",   ,      ,\n"
  "      \n"
  "   .\n\n"

  "     ,\n"
  "   ,      ,\n"
  "    ,\n"
  "      ,\n"
  "   ,  ,\n"
  "     \"\",  ",
  "                                   ===     ===",MB_OK);
}/*   fnAbout  */

/*        */
/*  ( ) wParam     */
void fnMainWindow_Command(WPARAM wParam)
{
  DWORD dwThreadId;//      

  switch (LOWORD(wParam))
  {
    case MENU_ESTIMATE://     
      CreateThread(NULL, 0,(LPTHREAD_START_ROUTINE)fnEstimate,/* */
        NULL,  /*    */
        0,/*     */
        &dwThreadId);/*  */
    break;
    case MENU_UPDATE://    
      CreateThread(NULL, 0,(LPTHREAD_START_ROUTINE)fnUpdate,/* */
        NULL,  /*    */
        0,/*     */
        &dwThreadId);/*  */
    break;
    //  
    case MENU_ABOUT:    fnAbout();        break;
    //  
    case MENU_EXIT:      SendMessage (hWndMain, WM_CLOSE, 0,0);  break;
    // 
    case MENU_TEST:      fnTest();
  }
}/*    fnMainWindow_Command  */
/******************************************************************************/
/*                                      */
/******************************************************************************/
//   
void fnMainWindow_Paint()
{ PAINTSTRUCT ps;
  RECT  rect;
  int x1=1+random(9);
  int x2=1+random(9);
  int x3=1+random(9);
  int x4=1+random(9);
  int y1=1+random(9);
  int y2=1+random(9);
  int y3=1+random(9);
  int y4=1+random(9);

  GetClientRect(hWndMain,&rect);
  rect.bottom-=20;//     

  float r=rect.right/2.0;
  float b=rect.bottom/2.0;
  float a;
  if(rect.bottom>rect.right)    a=r;
  else                          a=b;

  InvalidateRect(hWndMain,&rect,TRUE);
  HDC hdc=BeginPaint (hWndMain, &ps);
  HPEN hpen=CreatePen(PS_SOLID, a/50, RGB (255, 255, 0));
  SelectObject(hdc,hpen);
  MoveToEx(hdc,r,b, NULL);//   
  float t=0.0;
  float d=6.283185307179586/1000.0;// 2*Pi/1000
  for(DWORD i=0;i<1000;i++)
  { LineTo(hdc,  //   
      // x-  
      a*sin(x1*t)*sin(x2*t)*sin(x3*t)*sin(x4*t)+r,
      // y-  
      a*sin(y1*t)*sin(y2*t)*sin(y3*t)*sin(y4*t)+b
    );
    t+=d;
  }
  EndPaint(hWndMain, &ps);
  DeleteObject(hpen);
}/*    fnMainWindow_Paint  */

//   
void fnMainWindow_Create(HWND hwnd)
{
  if(GetCurrentDirectory(256,szExeDir)==0)
    MessageBox(hwnd,"GetCurrentDirectory(256,szExeDir)==0",
    "fnMainWindow_Create",MB_OK);// 

  randomize();//    
  hWndStatus=CreateStatusWindow(WS_CHILD|WS_VISIBLE,
     "  ",hwnd,0);
  //  
  hMsgFile=CreateFile ("MsgFile.txt", GENERIC_WRITE,
         FILE_SHARE_READ, NULL, OPEN_ALWAYS, FILE_ATTRIBUTE_NORMAL, NULL);
  SetFilePointer(hMsgFile,0,0,FILE_END);

  SetTimer (hwnd, 1, 10000, NULL);//  

  fnLoadStat();//  

  //    (  )
  DWORD dwThreadId;
  CreateThread(NULL,/*  */
    0,/*     */
    (LPTHREAD_START_ROUTINE)fnLoadHash128,/* */
    NULL,  /*    */
    0,/*     */
    &dwThreadId);/*  */
}/*    fnMainWindow_Create  */

//  
void fnMainWindow_Close()
{
  CloseHandle(hMsgFile);
  KillTimer(hWndMain,1);
}/*    fnMainWindow_Close  */

/*       */
LRESULT CALLBACK
fnMainWindowResponse(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
  switch (iMsg)/*      */
  { /*     ( ) */
    case WM_PAINT:    fnMainWindow_Paint();             return 0;
    // 
    case WM_TIMER:    fnMainWindow_Paint();             return 0;
      /*   ()  */
    case WM_COMMAND:  fnMainWindow_Command (wParam);    return 0;
      /*    (~3 )  */
    case WM_SIZE:
      SendMessage (hWndStatus, WM_SIZE, wParam, lParam);
    break;
    /*    (1 )  */
    case WM_CREATE:   fnMainWindow_Create(hwnd);        return 0;
    /*     (1 ) */
    case WM_CLOSE:
      fnMainWindow_Close();
    break;
    /*     (1 ) */
    case WM_DESTROY:          PostQuitMessage (0);      return 0;
  }
  /*    
  WM_MENUCHAR  WM_SETFOCUS  WM_SIZE */
  return DefWindowProc(hwnd, iMsg, wParam, lParam);
}/*   fnMainWindowResponse  */

/*     */
bool fnInitApplication(HINSTANCE hInstance)
{  InitCommonControls();//     
  WNDCLASSEX wndclass;/*      */
  wndclass.cbSize           = sizeof(WNDCLASSEX);
  //      ,   
  wndclass.style           = CS_DBLCLKS|CS_HREDRAW|CS_VREDRAW;
  wndclass.lpfnWndProc    = (WNDPROC)fnMainWindowResponse;
  wndclass.cbClsExtra      = 0;
  wndclass.cbWndExtra      = 0;
  wndclass.hInstance      = hInstance;
  // :  
  wndclass.hIcon          = LoadIcon (hInstance, MAKEINTRESOURCE(1));
  wndclass.hIconSm       = LoadIcon (hInstance, MAKEINTRESOURCE(1));
  wndclass.hCursor        = LoadCursor (NULL, IDC_ARROW);
  // :  
  wndclass.hbrBackground = CreateSolidBrush(0x00FF0000);
  wndclass.lpszMenuName   = MAKEINTRESOURCE(1);  //  
  wndclass.lpszClassName = szAppName;            //  
  if(!RegisterClassEx (&wndclass))/*       */
  { MessageBox(NULL,"  fnInitApplication",szAppName,MB_OK);
    return false;
  }
  return true;
}/*    fnInitApplication  */

/*   ,     */
int WINAPI WinMain (HINSTANCE hInst, HINSTANCE,
                    LPSTR /*lpCmdLine*/, int iCmdShow)
{
  if(!fnInitApplication(hInst)) return 0; /*     */
  hWndMain = CreateWindowEx ( /*    */
                WS_EX_APPWINDOW  ,//   drag-drop
                szAppName,
                szMainWindowTitle,
                WS_OVERLAPPEDWINDOW  ,
                CW_USEDEFAULT,    /*  x-  */
                CW_USEDEFAULT,    /*  y-  */
                CW_USEDEFAULT,    /*       */
                CW_USEDEFAULT,    /*       */
                NULL,
                NULL,
                hInst,
                NULL);
  if (!hWndMain){MessageBox(hWndMain,"!hWndMain",szAppName,MB_OK);return 0;}
  HACCEL hAcc=LoadAccelerators(hInst,MAKEINTRESOURCE(1));
  if(!hAcc){MessageBox(hWndMain,"!hAcc",szAppName,MB_OK);return 0;}
  ShowWindow (hWndMain,iCmdShow);
  MSG msg;
  while (GetMessage(&msg, NULL, NULL, NULL))
  {  if(!TranslateAccelerator(hWndMain,hAcc,&msg))
    { TranslateMessage(&msg);  //    
      DispatchMessage(&msg);   //   
    }
  }
  return msg.wParam;
}/*    WinMain  */
/******************************************************************************/
/*                                                                  */
/******************************************************************************/

